package com.ethon.tools;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

import javax.swing.JOptionPane;

import com.ethon.DataBase;
import com.ethon.mode.DataPoint;
import com.ethon.tools.CoordTransfer;

/**
 * ͼʾ
 * @author ethonchan	ethonchan@gmail.com
 *
 */
public class ImageGenerator {
	public static BufferedImage drawImage(BufferedImage bg,int side){
		BufferedImage img=new BufferedImage(side,side,BufferedImage.TYPE_INT_RGB);
		for(int i=0;i<side;i++){
			for(int j=0;j<side;j++){
				img.setRGB(i, j, new Color(255,255,255,0).getRGB());
			}
		}
		if(bg!=null){
			Graphics g = img.getGraphics();
			g.drawImage(bg, 0, 0, side, side, null);
			g.dispose();
		}			
		return img;
	}
	
	public static BufferedImage show_DataPoints_on_Image(DataPoint[] points, BufferedImage img){
		 if(points==null||points.length==0){
			Graphics g=img.getGraphics();
			g.setColor(new Color(0,0,0));
			g.drawString("", img.getHeight(null)/2-5, img.getHeight(null)/2);
			g.dispose();
		}else{
			Graphics g=img.getGraphics();
			CoordTransfer tfr=new CoordTransfer();
			
			for(int i=0;i<points.length;i++){
				g.setColor(points[i].getColor());
				int[] coord=tfr.getPanelCoord(points[i].getCoord_X(), points[i].getCoord_Y());
				g.fillOval(coord[0]-points[i].getRadium(), coord[1]-points[i].getRadium(), points[i].getRadium()*2, points[i].getRadium()*2);		
			}
			g.dispose();
		}
		return img;
	}
	
	public static BufferedImage show_DataPointCoord_on_Image(DataPoint[] points, BufferedImage image){
		if(points==null||points.length==0){
			JOptionPane.showMessageDialog(null, "δݵ");
			return image;
		}
		Graphics g=image.getGraphics();
		CoordTransfer tfr=new CoordTransfer();
		for(int i=0;i<points.length;i++){
			g.setColor(points[i].getColor());
			int[] coord=tfr.getPanelCoord(points[i].getCoord_X(), points[i].getCoord_Y());
			String str="("+points[i].getCoord_X()+","+points[i].getCoord_Y()+")";
			g.drawString(str, coord[0]-points[i].getRadium()-str.length(), coord[1]+points[i].getRadium()+10);
		}
		g.dispose();
		
		return image;
	}

	public static BufferedImage show_Coord_on_Image(BufferedImage image){
		if(DataBase.xMin==Double.MAX_VALUE){
			JOptionPane.showMessageDialog(null, "ͼδʼ");
			return image;
		}
		Graphics g=image.getGraphics();
		int[] coord=new CoordTransfer().getPanelCoord((DataBase.xMax+DataBase.xMin)/2, (DataBase.yMax+DataBase.yMin)/2);
		
		g.setColor(new Color(0,0,255));
		g.drawLine(0, coord[1], DataBase.sLen, coord[1]);
		g.fillPolygon(new int[]{DataBase.sLen-8,DataBase.sLen-8,DataBase.sLen}, new int[]{coord[1]-4,coord[1]+4,coord[1]}, 3);
		
		g.drawLine(coord[0], 0, coord[0], DataBase.sLen);
		g.fillPolygon(new int[]{coord[0]+4,coord[0]-4,coord[0]}, new int[]{DataBase.sLen-8,DataBase.sLen-8,DataBase.sLen}, 3);
		
		g.drawString("("+(DataBase.xMax+DataBase.xMin)/2+","+(DataBase.yMax+DataBase.yMin)/2+")", coord[0]+5, coord[1]+15);
		g.drawString("x", DataBase.sLen-15, coord[1]+15);
		g.drawString("y", coord[0]-15, DataBase.sLen-15);
		
		return image;
	}
	
	public static BufferedImage show_DataPoint_on_Image(BufferedImage image,DataPoint point,Color color){
		Graphics g=image.getGraphics();
		int[] coord=new CoordTransfer().getPanelCoord(point.getCoord_X(), point.getCoord_Y());
		g.setColor(color);
		int radium=point.getRadium();
		g.fillOval(coord[0]-radium, coord[1]-radium, 2*radium, 2*radium);
		g.dispose();
		return image;
	}
}
